package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.client._

/** Pointer for TokenReviewStatus */
final case class TokenReviewStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authentication.v1.TokenReviewStatus] {
  def audiences : ListPointer[String] = ListPointer(currentPath / s"audiences")
  def authenticated : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"authenticated")
  def error : Pointer.Plain[String] = Pointer.Plain(currentPath / s"error")
  def user :  io.k8s.api.authentication.v1.UserInfoPointer = io.k8s.api.authentication.v1.UserInfoPointer(currentPath / s"user")
}


