package dev.hnaderi.k8s.client.pointers.io.k8s.api.discovery.v1

import dev.hnaderi.k8s.client._

final case class EndpointSlicePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.discovery.v1.EndpointSlice] {
  def endpoints : ListPointer[io.k8s.api.discovery.v1.Endpoint] = ListPointer(currentPath / s"endpoints")
  def addressType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"addressType")
  def ports : ListPointer[io.k8s.api.discovery.v1.EndpointPort] = ListPointer(currentPath / s"ports")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


