package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class StorageOSVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.StorageOSVolumeSource] {
  def volumeNamespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeNamespace")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def secretRef :  pointers.io.k8s.api.core.v1.LocalObjectReferencePointer = pointers.io.k8s.api.core.v1.LocalObjectReferencePointer(currentPath / s"secretRef")
  def volumeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeName")
}


