package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class SecurityContextPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.SecurityContext] {
  def capabilities :  pointers.io.k8s.api.core.v1.CapabilitiesPointer = pointers.io.k8s.api.core.v1.CapabilitiesPointer(currentPath / s"capabilities")
  def readOnlyRootFilesystem : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnlyRootFilesystem")
  def allowPrivilegeEscalation : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"allowPrivilegeEscalation")
  def procMount : Pointer.Plain[String] = Pointer.Plain(currentPath / s"procMount")
  def runAsGroup : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"runAsGroup")
  def seccompProfile :  pointers.io.k8s.api.core.v1.SeccompProfilePointer = pointers.io.k8s.api.core.v1.SeccompProfilePointer(currentPath / s"seccompProfile")
  def windowsOptions :  pointers.io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer = pointers.io.k8s.api.core.v1.WindowsSecurityContextOptionsPointer(currentPath / s"windowsOptions")
  def seLinuxOptions :  pointers.io.k8s.api.core.v1.SELinuxOptionsPointer = pointers.io.k8s.api.core.v1.SELinuxOptionsPointer(currentPath / s"seLinuxOptions")
  def runAsUser : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"runAsUser")
  def privileged : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"privileged")
  def runAsNonRoot : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"runAsNonRoot")
}


