package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class CephFSPersistentVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.CephFSPersistentVolumeSource] {
  def monitors : ListPointer[String] = ListPointer(currentPath / s"monitors")
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def secretRef :  pointers.io.k8s.api.core.v1.SecretReferencePointer = pointers.io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"secretRef")
  def secretFile : Pointer.Plain[String] = Pointer.Plain(currentPath / s"secretFile")
  def user : Pointer.Plain[String] = Pointer.Plain(currentPath / s"user")
}


