package dev.hnaderi.k8s.client.pointers.io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s.client._

final case class HorizontalPodAutoscalerStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] {
  def desiredReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"desiredReplicas")
  def currentReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"currentReplicas")
  def lastScaleTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastScaleTime")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
  def currentCPUUtilizationPercentage : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"currentCPUUtilizationPercentage")
}


