package dev.hnaderi.k8s.client.pointers.io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s.client._

final case class HorizontalPodAutoscalerSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] {
  def maxReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"maxReplicas")
  def scaleTargetRef :  pointers.io.k8s.api.autoscaling.v1.CrossVersionObjectReferencePointer = pointers.io.k8s.api.autoscaling.v1.CrossVersionObjectReferencePointer(currentPath / s"scaleTargetRef")
  def minReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReplicas")
  def targetCPUUtilizationPercentage : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"targetCPUUtilizationPercentage")
}


