package dev.hnaderi.k8s.client.pointers.io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

final case class StatefulSetSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.StatefulSetSpec] {
  def serviceName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"serviceName")
  def template :  pointers.io.k8s.api.core.v1.PodTemplateSpecPointer = pointers.io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
  def selector :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
  def minReadySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReadySeconds")
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def revisionHistoryLimit : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"revisionHistoryLimit")
  def podManagementPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"podManagementPolicy")
  def volumeClaimTemplates : ListPointer[io.k8s.api.core.v1.PersistentVolumeClaim] = ListPointer(currentPath / s"volumeClaimTemplates")
  def persistentVolumeClaimRetentionPolicy :  pointers.io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicyPointer = pointers.io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicyPointer(currentPath / s"persistentVolumeClaimRetentionPolicy")
  def updateStrategy :  pointers.io.k8s.api.apps.v1.StatefulSetUpdateStrategyPointer = pointers.io.k8s.api.apps.v1.StatefulSetUpdateStrategyPointer(currentPath / s"updateStrategy")
}


