package dev.hnaderi.k8s.client.pointers.io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

final case class DeploymentStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.DeploymentStatus] {
  def conditions : ListPointer[io.k8s.api.apps.v1.DeploymentCondition] = ListPointer(currentPath / s"conditions")
  def collisionCount : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"collisionCount")
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def availableReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"availableReplicas")
  def unavailableReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"unavailableReplicas")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
  def updatedReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"updatedReplicas")
  def readyReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"readyReplicas")
}


