package dev.hnaderi.k8s.client.pointers.io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

final case class DaemonSetSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.DaemonSetSpec] {
  def template :  pointers.io.k8s.api.core.v1.PodTemplateSpecPointer = pointers.io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
  def selector :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
  def minReadySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReadySeconds")
  def revisionHistoryLimit : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"revisionHistoryLimit")
  def updateStrategy :  pointers.io.k8s.api.apps.v1.DaemonSetUpdateStrategyPointer = pointers.io.k8s.api.apps.v1.DaemonSetUpdateStrategyPointer(currentPath / s"updateStrategy")
}


