package dev.hnaderi.k8s.client.pointers.io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s.client._

final case class ValidatingWebhookPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.admissionregistration.v1.ValidatingWebhook] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def sideEffects : Pointer.Plain[String] = Pointer.Plain(currentPath / s"sideEffects")
  def clientConfig :  pointers.io.k8s.api.admissionregistration.v1.WebhookClientConfigPointer = pointers.io.k8s.api.admissionregistration.v1.WebhookClientConfigPointer(currentPath / s"clientConfig")
  def admissionReviewVersions : ListPointer[String] = ListPointer(currentPath / s"admissionReviewVersions")
  def timeoutSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"timeoutSeconds")
  def matchPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"matchPolicy")
  def namespaceSelector :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"namespaceSelector")
  def failurePolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"failurePolicy")
  def rules : ListPointer[io.k8s.api.admissionregistration.v1.RuleWithOperations] = ListPointer(currentPath / s"rules")
  def objectSelector :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"objectSelector")
}


