package io.k8s.api.resource.v1alpha2

import dev.hnaderi.k8s.client._

/** Pointer for StructuredResourceHandle */
final case class StructuredResourceHandlePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.resource.v1alpha2.StructuredResourceHandle] {
  def results : ListPointer[io.k8s.api.resource.v1alpha2.DriverAllocationResult] = ListPointer(currentPath / s"results")
  def nodeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nodeName")
  def vendorClaimParameters : Pointer.Plain[io.k8s.apimachinery.pkg.runtime.RawExtension] = Pointer.Plain(currentPath / s"vendorClaimParameters")
  def vendorClassParameters : Pointer.Plain[io.k8s.apimachinery.pkg.runtime.RawExtension] = Pointer.Plain(currentPath / s"vendorClassParameters")
}


