package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for ISCSIPersistentVolumeSource */
final case class ISCSIPersistentVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] {
  def iqn : Pointer.Plain[String] = Pointer.Plain(currentPath / s"iqn")
  def targetPortal : Pointer.Plain[String] = Pointer.Plain(currentPath / s"targetPortal")
  def lun : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"lun")
  def portals : ListPointer[String] = ListPointer(currentPath / s"portals")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def chapAuthDiscovery : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"chapAuthDiscovery")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def secretRef :  io.k8s.api.core.v1.SecretReferencePointer = io.k8s.api.core.v1.SecretReferencePointer(currentPath / s"secretRef")
  def initiatorName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"initiatorName")
  def iscsiInterface : Pointer.Plain[String] = Pointer.Plain(currentPath / s"iscsiInterface")
  def chapAuthSession : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"chapAuthSession")
}


