package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for CSIVolumeSource */
final case class CSIVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.CSIVolumeSource] {
  def driver : Pointer.Plain[String] = Pointer.Plain(currentPath / s"driver")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def volumeAttributes : MapPointer[String] = MapPointer(currentPath / s"volumeAttributes")
  def nodePublishSecretRef :  io.k8s.api.core.v1.LocalObjectReferencePointer = io.k8s.api.core.v1.LocalObjectReferencePointer(currentPath / s"nodePublishSecretRef")
}


