package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for VolumeProjection */
final case class VolumeProjectionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.VolumeProjection] {
  def configMap :  io.k8s.api.core.v1.ConfigMapProjectionPointer = io.k8s.api.core.v1.ConfigMapProjectionPointer(currentPath / s"configMap")
  def downwardAPI :  io.k8s.api.core.v1.DownwardAPIProjectionPointer = io.k8s.api.core.v1.DownwardAPIProjectionPointer(currentPath / s"downwardAPI")
  def secret :  io.k8s.api.core.v1.SecretProjectionPointer = io.k8s.api.core.v1.SecretProjectionPointer(currentPath / s"secret")
  def serviceAccountToken :  io.k8s.api.core.v1.ServiceAccountTokenProjectionPointer = io.k8s.api.core.v1.ServiceAccountTokenProjectionPointer(currentPath / s"serviceAccountToken")
}


