package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for DaemonSetCondition */
final case class DaemonSetConditionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.DaemonSetCondition] {
  def status : Pointer.Plain[String] = Pointer.Plain(currentPath / s"status")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def lastTransitionTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastTransitionTime")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
}


