package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for TypedObjectReference */
final case class TypedObjectReferencePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.TypedObjectReference] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def apiGroup : Pointer.Plain[String] = Pointer.Plain(currentPath / s"apiGroup")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
}


