package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.client._

/** Pointer for MetricTarget */
final case class MetricTargetPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.autoscaling.v2.MetricTarget] {
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def averageUtilization : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"averageUtilization")
  def averageValue : Pointer.Plain[io.k8s.apimachinery.pkg.api.resource.Quantity] = Pointer.Plain(currentPath / s"averageValue")
  def value : Pointer.Plain[io.k8s.apimachinery.pkg.api.resource.Quantity] = Pointer.Plain(currentPath / s"value")
}


