package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for SecretKeySelector */
final case class SecretKeySelectorPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.SecretKeySelector] {
  def key : Pointer.Plain[String] = Pointer.Plain(currentPath / s"key")
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def optional : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"optional")
}


