package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for Status */
final case class StatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.Status] {
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def code : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"code")
  def status : Pointer.Plain[String] = Pointer.Plain(currentPath / s"status")
  def details :  io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetailsPointer = io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetailsPointer(currentPath / s"details")
  def metadata :  io.k8s.apimachinery.pkg.apis.meta.v1.ListMetaPointer = io.k8s.apimachinery.pkg.apis.meta.v1.ListMetaPointer(currentPath / s"metadata")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
}


