package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for VolumeMountStatus */
final case class VolumeMountStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.VolumeMountStatus] {
  def mountPath : Pointer.Plain[String] = Pointer.Plain(currentPath / s"mountPath")
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def recursiveReadOnly : Pointer.Plain[String] = Pointer.Plain(currentPath / s"recursiveReadOnly")
}


