package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for StorageOSPersistentVolumeSource */
final case class StorageOSPersistentVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] {
  def volumeNamespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeNamespace")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def secretRef :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"secretRef")
  def volumeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeName")
}


