package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for PersistentVolumeSpec */
final case class PersistentVolumeSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PersistentVolumeSpec] {
  def scaleIO :  io.k8s.api.core.v1.ScaleIOPersistentVolumeSourcePointer = io.k8s.api.core.v1.ScaleIOPersistentVolumeSourcePointer(currentPath / s"scaleIO")
  def csi :  io.k8s.api.core.v1.CSIPersistentVolumeSourcePointer = io.k8s.api.core.v1.CSIPersistentVolumeSourcePointer(currentPath / s"csi")
  def accessModes : ListPointer[String] = ListPointer(currentPath / s"accessModes")
  def mountOptions : ListPointer[String] = ListPointer(currentPath / s"mountOptions")
  def nodeAffinity :  io.k8s.api.core.v1.VolumeNodeAffinityPointer = io.k8s.api.core.v1.VolumeNodeAffinityPointer(currentPath / s"nodeAffinity")
  def azureDisk :  io.k8s.api.core.v1.AzureDiskVolumeSourcePointer = io.k8s.api.core.v1.AzureDiskVolumeSourcePointer(currentPath / s"azureDisk")
  def azureFile :  io.k8s.api.core.v1.AzureFilePersistentVolumeSourcePointer = io.k8s.api.core.v1.AzureFilePersistentVolumeSourcePointer(currentPath / s"azureFile")
  def hostPath :  io.k8s.api.core.v1.HostPathVolumeSourcePointer = io.k8s.api.core.v1.HostPathVolumeSourcePointer(currentPath / s"hostPath")
  def rbd :  io.k8s.api.core.v1.RBDPersistentVolumeSourcePointer = io.k8s.api.core.v1.RBDPersistentVolumeSourcePointer(currentPath / s"rbd")
  def portworxVolume :  io.k8s.api.core.v1.PortworxVolumeSourcePointer = io.k8s.api.core.v1.PortworxVolumeSourcePointer(currentPath / s"portworxVolume")
  def persistentVolumeReclaimPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"persistentVolumeReclaimPolicy")
  def glusterfs :  io.k8s.api.core.v1.GlusterfsPersistentVolumeSourcePointer = io.k8s.api.core.v1.GlusterfsPersistentVolumeSourcePointer(currentPath / s"glusterfs")
  def volumeMode : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeMode")
  def flocker :  io.k8s.api.core.v1.FlockerVolumeSourcePointer = io.k8s.api.core.v1.FlockerVolumeSourcePointer(currentPath / s"flocker")
  def claimRef :  io.k8s.api.core.v1.ObjectReferencePointer = io.k8s.api.core.v1.ObjectReferencePointer(currentPath / s"claimRef")
  def fc :  io.k8s.api.core.v1.FCVolumeSourcePointer = io.k8s.api.core.v1.FCVolumeSourcePointer(currentPath / s"fc")
  def local :  io.k8s.api.core.v1.LocalVolumeSourcePointer = io.k8s.api.core.v1.LocalVolumeSourcePointer(currentPath / s"local")
  def storageClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storageClassName")
  def photonPersistentDisk :  io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer = io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer(currentPath / s"photonPersistentDisk")
  def gcePersistentDisk :  io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer = io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer(currentPath / s"gcePersistentDisk")
  def vsphereVolume :  io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer = io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer(currentPath / s"vsphereVolume")
  def iscsi :  io.k8s.api.core.v1.ISCSIPersistentVolumeSourcePointer = io.k8s.api.core.v1.ISCSIPersistentVolumeSourcePointer(currentPath / s"iscsi")
  def cinder :  io.k8s.api.core.v1.CinderPersistentVolumeSourcePointer = io.k8s.api.core.v1.CinderPersistentVolumeSourcePointer(currentPath / s"cinder")
  def cephfs :  io.k8s.api.core.v1.CephFSPersistentVolumeSourcePointer = io.k8s.api.core.v1.CephFSPersistentVolumeSourcePointer(currentPath / s"cephfs")
  def awsElasticBlockStore :  io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer = io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer(currentPath / s"awsElasticBlockStore")
  def flexVolume :  io.k8s.api.core.v1.FlexPersistentVolumeSourcePointer = io.k8s.api.core.v1.FlexPersistentVolumeSourcePointer(currentPath / s"flexVolume")
  def nfs :  io.k8s.api.core.v1.NFSVolumeSourcePointer = io.k8s.api.core.v1.NFSVolumeSourcePointer(currentPath / s"nfs")
  def quobyte :  io.k8s.api.core.v1.QuobyteVolumeSourcePointer = io.k8s.api.core.v1.QuobyteVolumeSourcePointer(currentPath / s"quobyte")
  def storageos :  io.k8s.api.core.v1.StorageOSPersistentVolumeSourcePointer = io.k8s.api.core.v1.StorageOSPersistentVolumeSourcePointer(currentPath / s"storageos")
  def capacity : MapPointer[io.k8s.apimachinery.pkg.api.resource.Quantity] = MapPointer(currentPath / s"capacity")
}


