package io.k8s.api.batch.v1

import dev.hnaderi.k8s.client._

/** Pointer for JobStatus */
final case class JobStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.batch.v1.JobStatus] {
  def conditions : ListPointer[io.k8s.api.batch.v1.JobCondition] = ListPointer(currentPath / s"conditions")
  def terminating : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"terminating")
  def uncountedTerminatedPods :  io.k8s.api.batch.v1.UncountedTerminatedPodsPointer = io.k8s.api.batch.v1.UncountedTerminatedPodsPointer(currentPath / s"uncountedTerminatedPods")
  def completedIndexes : Pointer.Plain[String] = Pointer.Plain(currentPath / s"completedIndexes")
  def startTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"startTime")
  def ready : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"ready")
  def failed : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"failed")
  def succeeded : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"succeeded")
  def completionTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"completionTime")
  def failedIndexes : Pointer.Plain[String] = Pointer.Plain(currentPath / s"failedIndexes")
  def active : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"active")
}


