package io.k8s.api.networking.v1

import dev.hnaderi.k8s.client._

/** Pointer for IngressLoadBalancerIngress */
final case class IngressLoadBalancerIngressPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.networking.v1.IngressLoadBalancerIngress] {
  def hostname : Pointer.Plain[String] = Pointer.Plain(currentPath / s"hostname")
  def ip : Pointer.Plain[String] = Pointer.Plain(currentPath / s"ip")
  def ports : ListPointer[io.k8s.api.networking.v1.IngressPortStatus] = ListPointer(currentPath / s"ports")
}


