package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.client._

/** Pointer for ResourcePolicyRule */
final case class ResourcePolicyRulePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule] {
  def verbs : ListPointer[String] = ListPointer(currentPath / s"verbs")
  def apiGroups : ListPointer[String] = ListPointer(currentPath / s"apiGroups")
  def resources : ListPointer[String] = ListPointer(currentPath / s"resources")
  def clusterScope : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"clusterScope")
  def namespaces : ListPointer[String] = ListPointer(currentPath / s"namespaces")
}


