package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.client._

/** Pointer for UserInfo */
final case class UserInfoPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authentication.v1.UserInfo] {
  def extra : MapPointer[Seq[String]] = MapPointer(currentPath / s"extra")
  def groups : ListPointer[String] = ListPointer(currentPath / s"groups")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def username : Pointer.Plain[String] = Pointer.Plain(currentPath / s"username")
}


