package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for PodStatus */
final case class PodStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PodStatus] {
  def conditions : ListPointer[io.k8s.api.core.v1.PodCondition] = ListPointer(currentPath / s"conditions")
  def qosClass : Pointer.Plain[String] = Pointer.Plain(currentPath / s"qosClass")
  def startTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"startTime")
  def phase : Pointer.Plain[String] = Pointer.Plain(currentPath / s"phase")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def ephemeralContainerStatuses : ListPointer[io.k8s.api.core.v1.ContainerStatus] = ListPointer(currentPath / s"ephemeralContainerStatuses")
  def hostIP : Pointer.Plain[String] = Pointer.Plain(currentPath / s"hostIP")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
  def containerStatuses : ListPointer[io.k8s.api.core.v1.ContainerStatus] = ListPointer(currentPath / s"containerStatuses")
  def podIP : Pointer.Plain[String] = Pointer.Plain(currentPath / s"podIP")
  def nominatedNodeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"nominatedNodeName")
  def podIPs : ListPointer[io.k8s.api.core.v1.PodIP] = ListPointer(currentPath / s"podIPs")
  def initContainerStatuses : ListPointer[io.k8s.api.core.v1.ContainerStatus] = ListPointer(currentPath / s"initContainerStatuses")
}


