package io.k8s.api.networking.v1

import dev.hnaderi.k8s.client._

/** Pointer for IngressClassParametersReference */
final case class IngressClassParametersReferencePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.networking.v1.IngressClassParametersReference] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def scope : Pointer.Plain[String] = Pointer.Plain(currentPath / s"scope")
  def apiGroup : Pointer.Plain[String] = Pointer.Plain(currentPath / s"apiGroup")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
}


