package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.client._

/** Pointer for HorizontalPodAutoscalerStatus */
final case class HorizontalPodAutoscalerStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus] {
  def desiredReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"desiredReplicas")
  def currentReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"currentReplicas")
  def conditions : ListPointer[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerCondition] = ListPointer(currentPath / s"conditions")
  def currentMetrics : ListPointer[io.k8s.api.autoscaling.v2beta2.MetricStatus] = ListPointer(currentPath / s"currentMetrics")
  def lastScaleTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastScaleTime")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
}


