package io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

/** Pointer for StatefulSetSpec */
final case class StatefulSetSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.StatefulSetSpec] {
  def serviceName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"serviceName")
  def template :  io.k8s.api.core.v1.PodTemplateSpecPointer = io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
  def selector :  io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
  def minReadySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReadySeconds")
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def revisionHistoryLimit : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"revisionHistoryLimit")
  def podManagementPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"podManagementPolicy")
  def volumeClaimTemplates : ListPointer[io.k8s.api.core.v1.PersistentVolumeClaim] = ListPointer(currentPath / s"volumeClaimTemplates")
  def persistentVolumeClaimRetentionPolicy :  io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicyPointer = io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicyPointer(currentPath / s"persistentVolumeClaimRetentionPolicy")
  def updateStrategy :  io.k8s.api.apps.v1.StatefulSetUpdateStrategyPointer = io.k8s.api.apps.v1.StatefulSetUpdateStrategyPointer(currentPath / s"updateStrategy")
}


