package dev.hnaderi.k8s.client.pointers.io.k8s.api.node.v1

import dev.hnaderi.k8s.client._

final case class RuntimeClassPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.node.v1.RuntimeClass] {
  def handler : Pointer.Plain[String] = Pointer.Plain(currentPath / s"handler")
  def scheduling :  pointers.io.k8s.api.node.v1.SchedulingPointer = pointers.io.k8s.api.node.v1.SchedulingPointer(currentPath / s"scheduling")
  def overhead :  pointers.io.k8s.api.node.v1.OverheadPointer = pointers.io.k8s.api.node.v1.OverheadPointer(currentPath / s"overhead")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


