package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class VolumePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Volume] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def secret :  pointers.io.k8s.api.core.v1.SecretVolumeSourcePointer = pointers.io.k8s.api.core.v1.SecretVolumeSourcePointer(currentPath / s"secret")
  def scaleIO :  pointers.io.k8s.api.core.v1.ScaleIOVolumeSourcePointer = pointers.io.k8s.api.core.v1.ScaleIOVolumeSourcePointer(currentPath / s"scaleIO")
  def csi :  pointers.io.k8s.api.core.v1.CSIVolumeSourcePointer = pointers.io.k8s.api.core.v1.CSIVolumeSourcePointer(currentPath / s"csi")
  def azureDisk :  pointers.io.k8s.api.core.v1.AzureDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.AzureDiskVolumeSourcePointer(currentPath / s"azureDisk")
  def azureFile :  pointers.io.k8s.api.core.v1.AzureFileVolumeSourcePointer = pointers.io.k8s.api.core.v1.AzureFileVolumeSourcePointer(currentPath / s"azureFile")
  def hostPath :  pointers.io.k8s.api.core.v1.HostPathVolumeSourcePointer = pointers.io.k8s.api.core.v1.HostPathVolumeSourcePointer(currentPath / s"hostPath")
  def rbd :  pointers.io.k8s.api.core.v1.RBDVolumeSourcePointer = pointers.io.k8s.api.core.v1.RBDVolumeSourcePointer(currentPath / s"rbd")
  def configMap :  pointers.io.k8s.api.core.v1.ConfigMapVolumeSourcePointer = pointers.io.k8s.api.core.v1.ConfigMapVolumeSourcePointer(currentPath / s"configMap")
  def portworxVolume :  pointers.io.k8s.api.core.v1.PortworxVolumeSourcePointer = pointers.io.k8s.api.core.v1.PortworxVolumeSourcePointer(currentPath / s"portworxVolume")
  def glusterfs :  pointers.io.k8s.api.core.v1.GlusterfsVolumeSourcePointer = pointers.io.k8s.api.core.v1.GlusterfsVolumeSourcePointer(currentPath / s"glusterfs")
  def flocker :  pointers.io.k8s.api.core.v1.FlockerVolumeSourcePointer = pointers.io.k8s.api.core.v1.FlockerVolumeSourcePointer(currentPath / s"flocker")
  def fc :  pointers.io.k8s.api.core.v1.FCVolumeSourcePointer = pointers.io.k8s.api.core.v1.FCVolumeSourcePointer(currentPath / s"fc")
  def photonPersistentDisk :  pointers.io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.PhotonPersistentDiskVolumeSourcePointer(currentPath / s"photonPersistentDisk")
  def gcePersistentDisk :  pointers.io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.GCEPersistentDiskVolumeSourcePointer(currentPath / s"gcePersistentDisk")
  def persistentVolumeClaim :  pointers.io.k8s.api.core.v1.PersistentVolumeClaimVolumeSourcePointer = pointers.io.k8s.api.core.v1.PersistentVolumeClaimVolumeSourcePointer(currentPath / s"persistentVolumeClaim")
  def vsphereVolume :  pointers.io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer = pointers.io.k8s.api.core.v1.VsphereVirtualDiskVolumeSourcePointer(currentPath / s"vsphereVolume")
  def projected :  pointers.io.k8s.api.core.v1.ProjectedVolumeSourcePointer = pointers.io.k8s.api.core.v1.ProjectedVolumeSourcePointer(currentPath / s"projected")
  def ephemeral :  pointers.io.k8s.api.core.v1.EphemeralVolumeSourcePointer = pointers.io.k8s.api.core.v1.EphemeralVolumeSourcePointer(currentPath / s"ephemeral")
  def iscsi :  pointers.io.k8s.api.core.v1.ISCSIVolumeSourcePointer = pointers.io.k8s.api.core.v1.ISCSIVolumeSourcePointer(currentPath / s"iscsi")
  def cinder :  pointers.io.k8s.api.core.v1.CinderVolumeSourcePointer = pointers.io.k8s.api.core.v1.CinderVolumeSourcePointer(currentPath / s"cinder")
  def gitRepo :  pointers.io.k8s.api.core.v1.GitRepoVolumeSourcePointer = pointers.io.k8s.api.core.v1.GitRepoVolumeSourcePointer(currentPath / s"gitRepo")
  def cephfs :  pointers.io.k8s.api.core.v1.CephFSVolumeSourcePointer = pointers.io.k8s.api.core.v1.CephFSVolumeSourcePointer(currentPath / s"cephfs")
  def awsElasticBlockStore :  pointers.io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer = pointers.io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSourcePointer(currentPath / s"awsElasticBlockStore")
  def downwardAPI :  pointers.io.k8s.api.core.v1.DownwardAPIVolumeSourcePointer = pointers.io.k8s.api.core.v1.DownwardAPIVolumeSourcePointer(currentPath / s"downwardAPI")
  def flexVolume :  pointers.io.k8s.api.core.v1.FlexVolumeSourcePointer = pointers.io.k8s.api.core.v1.FlexVolumeSourcePointer(currentPath / s"flexVolume")
  def emptyDir :  pointers.io.k8s.api.core.v1.EmptyDirVolumeSourcePointer = pointers.io.k8s.api.core.v1.EmptyDirVolumeSourcePointer(currentPath / s"emptyDir")
  def nfs :  pointers.io.k8s.api.core.v1.NFSVolumeSourcePointer = pointers.io.k8s.api.core.v1.NFSVolumeSourcePointer(currentPath / s"nfs")
  def quobyte :  pointers.io.k8s.api.core.v1.QuobyteVolumeSourcePointer = pointers.io.k8s.api.core.v1.QuobyteVolumeSourcePointer(currentPath / s"quobyte")
  def storageos :  pointers.io.k8s.api.core.v1.StorageOSVolumeSourcePointer = pointers.io.k8s.api.core.v1.StorageOSVolumeSourcePointer(currentPath / s"storageos")
}


