package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ServiceSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ServiceSpec] {
  def sessionAffinityConfig :  pointers.io.k8s.api.core.v1.SessionAffinityConfigPointer = pointers.io.k8s.api.core.v1.SessionAffinityConfigPointer(currentPath / s"sessionAffinityConfig")
  def loadBalancerSourceRanges : ListPointer[String] = ListPointer(currentPath / s"loadBalancerSourceRanges")
  def sessionAffinity : Pointer.Plain[String] = Pointer.Plain(currentPath / s"sessionAffinity")
  def clusterIPs : ListPointer[String] = ListPointer(currentPath / s"clusterIPs")
  def externalTrafficPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"externalTrafficPolicy")
  def loadBalancerIP : Pointer.Plain[String] = Pointer.Plain(currentPath / s"loadBalancerIP")
  def clusterIP : Pointer.Plain[String] = Pointer.Plain(currentPath / s"clusterIP")
  def ports : ListPointer[io.k8s.api.core.v1.ServicePort] = ListPointer(currentPath / s"ports")
  def healthCheckNodePort : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"healthCheckNodePort")
  def allocateLoadBalancerNodePorts : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"allocateLoadBalancerNodePorts")
  def externalIPs : ListPointer[String] = ListPointer(currentPath / s"externalIPs")
  def ipFamilies : ListPointer[String] = ListPointer(currentPath / s"ipFamilies")
  def internalTrafficPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"internalTrafficPolicy")
  def externalName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"externalName")
  def ipFamilyPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"ipFamilyPolicy")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def selector : MapPointer[String] = MapPointer(currentPath / s"selector")
  def loadBalancerClass : Pointer.Plain[String] = Pointer.Plain(currentPath / s"loadBalancerClass")
  def publishNotReadyAddresses : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"publishNotReadyAddresses")
}


