package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ServiceAccountPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.ServiceAccount] {
  def imagePullSecrets : ListPointer[io.k8s.api.core.v1.LocalObjectReference] = ListPointer(currentPath / s"imagePullSecrets")
  def secrets : ListPointer[io.k8s.api.core.v1.ObjectReference] = ListPointer(currentPath / s"secrets")
  def automountServiceAccountToken : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"automountServiceAccountToken")
  def metadata :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMetaPointer(currentPath / s"metadata")
}


