package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class RBDVolumeSourcePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.RBDVolumeSource] {
  def image : Pointer.Plain[String] = Pointer.Plain(currentPath / s"image")
  def monitors : ListPointer[String] = ListPointer(currentPath / s"monitors")
  def readOnly : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"readOnly")
  def fsType : Pointer.Plain[String] = Pointer.Plain(currentPath / s"fsType")
  def secretRef :  pointers.io.k8s.api.core.v1.LocalObjectReferencePointer = pointers.io.k8s.api.core.v1.LocalObjectReferencePointer(currentPath / s"secretRef")
  def pool : Pointer.Plain[String] = Pointer.Plain(currentPath / s"pool")
  def keyring : Pointer.Plain[String] = Pointer.Plain(currentPath / s"keyring")
  def user : Pointer.Plain[String] = Pointer.Plain(currentPath / s"user")
}


