package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class ProbePointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.Probe] {
  def timeoutSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"timeoutSeconds")
  def grpc :  pointers.io.k8s.api.core.v1.GRPCActionPointer = pointers.io.k8s.api.core.v1.GRPCActionPointer(currentPath / s"grpc")
  def tcpSocket :  pointers.io.k8s.api.core.v1.TCPSocketActionPointer = pointers.io.k8s.api.core.v1.TCPSocketActionPointer(currentPath / s"tcpSocket")
  def initialDelaySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"initialDelaySeconds")
  def failureThreshold : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"failureThreshold")
  def httpGet :  pointers.io.k8s.api.core.v1.HTTPGetActionPointer = pointers.io.k8s.api.core.v1.HTTPGetActionPointer(currentPath / s"httpGet")
  def terminationGracePeriodSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"terminationGracePeriodSeconds")
  def exec :  pointers.io.k8s.api.core.v1.ExecActionPointer = pointers.io.k8s.api.core.v1.ExecActionPointer(currentPath / s"exec")
  def periodSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"periodSeconds")
  def successThreshold : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"successThreshold")
}


