package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class PodConditionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PodCondition] {
  def status : Pointer.Plain[String] = Pointer.Plain(currentPath / s"status")
  def `type` : Pointer.Plain[String] = Pointer.Plain(currentPath / s"type")
  def lastProbeTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastProbeTime")
  def reason : Pointer.Plain[String] = Pointer.Plain(currentPath / s"reason")
  def lastTransitionTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"lastTransitionTime")
  def message : Pointer.Plain[String] = Pointer.Plain(currentPath / s"message")
}


