package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class PersistentVolumeClaimSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.PersistentVolumeClaimSpec] {
  def accessModes : ListPointer[String] = ListPointer(currentPath / s"accessModes")
  def volumeMode : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeMode")
  def dataSourceRef :  pointers.io.k8s.api.core.v1.TypedLocalObjectReferencePointer = pointers.io.k8s.api.core.v1.TypedLocalObjectReferencePointer(currentPath / s"dataSourceRef")
  def storageClassName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"storageClassName")
  def dataSource :  pointers.io.k8s.api.core.v1.TypedLocalObjectReferencePointer = pointers.io.k8s.api.core.v1.TypedLocalObjectReferencePointer(currentPath / s"dataSource")
  def volumeName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"volumeName")
  def resources :  pointers.io.k8s.api.core.v1.ResourceRequirementsPointer = pointers.io.k8s.api.core.v1.ResourceRequirementsPointer(currentPath / s"resources")
  def selector :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
}


