package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class NodeSystemInfoPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.NodeSystemInfo] {
  def systemUUID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"systemUUID")
  def osImage : Pointer.Plain[String] = Pointer.Plain(currentPath / s"osImage")
  def machineID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"machineID")
  def bootID : Pointer.Plain[String] = Pointer.Plain(currentPath / s"bootID")
  def architecture : Pointer.Plain[String] = Pointer.Plain(currentPath / s"architecture")
  def kubeletVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kubeletVersion")
  def operatingSystem : Pointer.Plain[String] = Pointer.Plain(currentPath / s"operatingSystem")
  def kubeProxyVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kubeProxyVersion")
  def containerRuntimeVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"containerRuntimeVersion")
  def kernelVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"kernelVersion")
}


