package dev.hnaderi.k8s.client.pointers.io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

final case class EphemeralContainerPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.EphemeralContainer] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def readinessProbe :  pointers.io.k8s.api.core.v1.ProbePointer = pointers.io.k8s.api.core.v1.ProbePointer(currentPath / s"readinessProbe")
  def livenessProbe :  pointers.io.k8s.api.core.v1.ProbePointer = pointers.io.k8s.api.core.v1.ProbePointer(currentPath / s"livenessProbe")
  def lifecycle :  pointers.io.k8s.api.core.v1.LifecyclePointer = pointers.io.k8s.api.core.v1.LifecyclePointer(currentPath / s"lifecycle")
  def image : Pointer.Plain[String] = Pointer.Plain(currentPath / s"image")
  def stdinOnce : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"stdinOnce")
  def ports : ListPointer[io.k8s.api.core.v1.ContainerPort] = ListPointer(currentPath / s"ports")
  def startupProbe :  pointers.io.k8s.api.core.v1.ProbePointer = pointers.io.k8s.api.core.v1.ProbePointer(currentPath / s"startupProbe")
  def command : ListPointer[String] = ListPointer(currentPath / s"command")
  def terminationMessagePolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"terminationMessagePolicy")
  def targetContainerName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"targetContainerName")
  def stdin : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"stdin")
  def terminationMessagePath : Pointer.Plain[String] = Pointer.Plain(currentPath / s"terminationMessagePath")
  def resources :  pointers.io.k8s.api.core.v1.ResourceRequirementsPointer = pointers.io.k8s.api.core.v1.ResourceRequirementsPointer(currentPath / s"resources")
  def envFrom : ListPointer[io.k8s.api.core.v1.EnvFromSource] = ListPointer(currentPath / s"envFrom")
  def volumeDevices : ListPointer[io.k8s.api.core.v1.VolumeDevice] = ListPointer(currentPath / s"volumeDevices")
  def args : ListPointer[String] = ListPointer(currentPath / s"args")
  def tty : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"tty")
  def imagePullPolicy : Pointer.Plain[String] = Pointer.Plain(currentPath / s"imagePullPolicy")
  def workingDir : Pointer.Plain[String] = Pointer.Plain(currentPath / s"workingDir")
  def volumeMounts : ListPointer[io.k8s.api.core.v1.VolumeMount] = ListPointer(currentPath / s"volumeMounts")
  def env : ListPointer[io.k8s.api.core.v1.EnvVar] = ListPointer(currentPath / s"env")
  def securityContext :  pointers.io.k8s.api.core.v1.SecurityContextPointer = pointers.io.k8s.api.core.v1.SecurityContextPointer(currentPath / s"securityContext")
}


