package dev.hnaderi.k8s.client.pointers.io.k8s.api.certificates.v1

import dev.hnaderi.k8s.client._

final case class CertificateSigningRequestSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.certificates.v1.CertificateSigningRequestSpec] {
  def request : Pointer.Plain[String] = Pointer.Plain(currentPath / s"request")
  def signerName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"signerName")
  def usages : ListPointer[String] = ListPointer(currentPath / s"usages")
  def username : Pointer.Plain[String] = Pointer.Plain(currentPath / s"username")
  def expirationSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"expirationSeconds")
  def groups : ListPointer[String] = ListPointer(currentPath / s"groups")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def extra : MapPointer[Seq[String]] = MapPointer(currentPath / s"extra")
}


