package dev.hnaderi.k8s.client.pointers.io.k8s.api.batch.v1

import dev.hnaderi.k8s.client._

final case class JobStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.batch.v1.JobStatus] {
  def conditions : ListPointer[io.k8s.api.batch.v1.JobCondition] = ListPointer(currentPath / s"conditions")
  def uncountedTerminatedPods :  pointers.io.k8s.api.batch.v1.UncountedTerminatedPodsPointer = pointers.io.k8s.api.batch.v1.UncountedTerminatedPodsPointer(currentPath / s"uncountedTerminatedPods")
  def completedIndexes : Pointer.Plain[String] = Pointer.Plain(currentPath / s"completedIndexes")
  def startTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"startTime")
  def ready : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"ready")
  def failed : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"failed")
  def succeeded : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"succeeded")
  def completionTime : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"completionTime")
  def active : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"active")
}


