package dev.hnaderi.k8s.client.pointers.io.k8s.api.authentication.v1

import dev.hnaderi.k8s.client._

final case class TokenReviewStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.authentication.v1.TokenReviewStatus] {
  def audiences : ListPointer[String] = ListPointer(currentPath / s"audiences")
  def authenticated : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"authenticated")
  def error : Pointer.Plain[String] = Pointer.Plain(currentPath / s"error")
  def user :  pointers.io.k8s.api.authentication.v1.UserInfoPointer = pointers.io.k8s.api.authentication.v1.UserInfoPointer(currentPath / s"user")
}


