package dev.hnaderi.k8s.client.pointers.io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

final case class ReplicaSetStatusPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.ReplicaSetStatus] {
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def conditions : ListPointer[io.k8s.api.apps.v1.ReplicaSetCondition] = ListPointer(currentPath / s"conditions")
  def availableReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"availableReplicas")
  def observedGeneration : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"observedGeneration")
  def readyReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"readyReplicas")
  def fullyLabeledReplicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"fullyLabeledReplicas")
}


