package dev.hnaderi.k8s.client.pointers.io.k8s.api.apps.v1

import dev.hnaderi.k8s.client._

final case class DeploymentSpecPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.apps.v1.DeploymentSpec] {
  def template :  pointers.io.k8s.api.core.v1.PodTemplateSpecPointer = pointers.io.k8s.api.core.v1.PodTemplateSpecPointer(currentPath / s"template")
  def selector :  pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer = pointers.io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorPointer(currentPath / s"selector")
  def minReadySeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"minReadySeconds")
  def progressDeadlineSeconds : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"progressDeadlineSeconds")
  def replicas : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"replicas")
  def revisionHistoryLimit : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"revisionHistoryLimit")
  def paused : Pointer.Plain[Boolean] = Pointer.Plain(currentPath / s"paused")
  def strategy :  pointers.io.k8s.api.apps.v1.DeploymentStrategyPointer = pointers.io.k8s.api.apps.v1.DeploymentStrategyPointer(currentPath / s"strategy")
}


