package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.client._

/** Pointer for ObjectMeta */
final case class ObjectMetaPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] {
  def name : Pointer.Plain[String] = Pointer.Plain(currentPath / s"name")
  def ownerReferences : ListPointer[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference] = ListPointer(currentPath / s"ownerReferences")
  def creationTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"creationTimestamp")
  def generation : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"generation")
  def resourceVersion : Pointer.Plain[String] = Pointer.Plain(currentPath / s"resourceVersion")
  def generateName : Pointer.Plain[String] = Pointer.Plain(currentPath / s"generateName")
  def deletionGracePeriodSeconds : Pointer.Plain[Long] = Pointer.Plain(currentPath / s"deletionGracePeriodSeconds")
  def selfLink : Pointer.Plain[String] = Pointer.Plain(currentPath / s"selfLink")
  def finalizers : ListPointer[String] = ListPointer(currentPath / s"finalizers")
  def annotations : MapPointer[String] = MapPointer(currentPath / s"annotations")
  def managedFields : ListPointer[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry] = ListPointer(currentPath / s"managedFields")
  def labels : MapPointer[String] = MapPointer(currentPath / s"labels")
  def uid : Pointer.Plain[String] = Pointer.Plain(currentPath / s"uid")
  def namespace : Pointer.Plain[String] = Pointer.Plain(currentPath / s"namespace")
  def deletionTimestamp : Pointer.Plain[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = Pointer.Plain(currentPath / s"deletionTimestamp")
}


