package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for KeyToPath */
final case class KeyToPathPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.KeyToPath] {
  def key : Pointer.Plain[String] = Pointer.Plain(currentPath / s"key")
  def path : Pointer.Plain[String] = Pointer.Plain(currentPath / s"path")
  def mode : Pointer.Plain[Int] = Pointer.Plain(currentPath / s"mode")
}


