/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.APIVerb;
import dev.hnaderi.k8s.client.APIVerb$DELETE$;
import dev.hnaderi.k8s.client.APIVerb$GET$;
import dev.hnaderi.k8s.client.APIVerb$PATCH$;
import dev.hnaderi.k8s.client.APIVerb$POST$;
import dev.hnaderi.k8s.client.APIVerb$PUT$;
import dev.hnaderi.k8s.client.AuthenticationParams;
import dev.hnaderi.k8s.client.HttpBackend;
import dev.hnaderi.k8s.client.HttpClient$;
import dev.hnaderi.k8s.client.HttpRequest;
import dev.hnaderi.k8s.client.PatchType;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public interface HttpClient<F> {
    public static <F> HttpClient<F> apply(String string, HttpBackend<F> httpBackend, AuthenticationParams authenticationParams) {
        return HttpClient$.MODULE$.apply(string, httpBackend, authenticationParams);
    }

    public static <F, S> HttpClient<F> streaming(String string, HttpBackend<F> httpBackend, AuthenticationParams authenticationParams) {
        return HttpClient$.MODULE$.streaming(string, httpBackend, authenticationParams);
    }

    public static <F> AuthenticationParams apply$default$3() {
        return HttpClient$.MODULE$.apply$default$3();
    }

    public static <F, S> AuthenticationParams streaming$default$3() {
        return HttpClient$.MODULE$.streaming$default$3();
    }

    public <O> F get(String var1, Seq<Tuple2<String, String>> var2, Decoder<O> var3);

    public <I, O> F post(String var1, Seq<Tuple2<String, String>> var2, I var3, Encoder<I> var4, Decoder<O> var5);

    public <I, O> F put(String var1, Seq<Tuple2<String, String>> var2, I var3, Encoder<I> var4, Decoder<O> var5);

    public <I, O> F patch(String var1, PatchType var2, Seq<Tuple2<String, String>> var3, I var4, Encoder<I> var5, Decoder<O> var6);

    public <I, O> F delete(String var1, Seq<Tuple2<String, String>> var2, Option<I> var3, Encoder<I> var4, Decoder<O> var5);

    public static None$ delete$default$3$(HttpClient $this, String url, Seq params) {
        return $this.delete$default$3(url, (Seq<Tuple2<String, String>>)params);
    }

    default public <I, O> None$ delete$default$3(String url, Seq<Tuple2<String, String>> params) {
        return None$.MODULE$;
    }

    public static Object send$(HttpClient $this, HttpRequest req) {
        return $this.send(req);
    }

    default public <O> F send(HttpRequest<O> req) {
        return (F)req.send(this);
    }

    public static abstract class Simple<F>
    implements HttpClient<F> {
        private final String baseUri;
        private final HttpBackend<F> backend;
        private final AuthenticationParams auth;

        public Simple(String baseUri, HttpBackend<F> backend, AuthenticationParams auth) {
            this.baseUri = baseUri;
            this.backend = backend;
            this.auth = auth;
        }

        @Override
        public <O> F get(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$11) {
            String string = this.baseUri + url;
            APIVerb$GET$ aPIVerb$GET$ = APIVerb$GET$.MODULE$;
            Seq seq = (Seq)params.$plus$plus(this.auth.params());
            return this.backend.send(string, aPIVerb$GET$, this.auth.headers(), (Seq<Tuple2<String, String>>)seq, this.auth.cookies(), evidence$11);
        }

        @Override
        public <I, O> F post(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$12, Decoder<O> evidence$13) {
            String string = this.baseUri + url;
            APIVerb$POST$ aPIVerb$POST$ = APIVerb$POST$.MODULE$;
            Seq seq = (Seq)params.$plus$plus(this.auth.params());
            return this.backend.send(string, aPIVerb$POST$, body, this.auth.headers(), (Seq<Tuple2<String, String>>)seq, this.auth.cookies(), evidence$12, evidence$13);
        }

        @Override
        public <I, O> F put(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$14, Decoder<O> evidence$15) {
            String string = this.baseUri + url;
            APIVerb$PUT$ aPIVerb$PUT$ = APIVerb$PUT$.MODULE$;
            Seq seq = (Seq)params.$plus$plus(this.auth.params());
            return this.backend.send(string, aPIVerb$PUT$, body, this.auth.headers(), (Seq<Tuple2<String, String>>)seq, this.auth.cookies(), evidence$14, evidence$15);
        }

        @Override
        public <I, O> F patch(String url, PatchType patch, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$16, Decoder<O> evidence$17) {
            String string = this.baseUri + url;
            APIVerb.PATCH pATCH = APIVerb$PATCH$.MODULE$.apply(patch);
            Seq seq = (Seq)params.$plus$plus(this.auth.params());
            return this.backend.send(string, pATCH, body, this.auth.headers(), (Seq<Tuple2<String, String>>)seq, this.auth.cookies(), evidence$16, evidence$17);
        }

        @Override
        public <I, O> F delete(String url, Seq<Tuple2<String, String>> params, Option<I> body, Encoder<I> evidence$18, Decoder<O> evidence$19) {
            String string = this.baseUri + url;
            APIVerb$DELETE$ aPIVerb$DELETE$ = APIVerb$DELETE$.MODULE$;
            Seq seq = (Seq)params.$plus$plus(this.auth.params());
            return this.backend.send(string, aPIVerb$DELETE$, this.auth.headers(), (Seq<Tuple2<String, String>>)seq, this.auth.cookies(), evidence$19);
        }
    }
}

