package io.k8s.api.core.v1

import dev.hnaderi.k8s.client._

/** Pointer for VolumeProjection */
final case class VolumeProjectionPointer(currentPath: PointerPath = PointerPath()) extends Pointer[io.k8s.api.core.v1.VolumeProjection] {
  def secret :  io.k8s.api.core.v1.SecretProjectionPointer = io.k8s.api.core.v1.SecretProjectionPointer(currentPath / s"secret")
  def configMap :  io.k8s.api.core.v1.ConfigMapProjectionPointer = io.k8s.api.core.v1.ConfigMapProjectionPointer(currentPath / s"configMap")
  def clusterTrustBundle :  io.k8s.api.core.v1.ClusterTrustBundleProjectionPointer = io.k8s.api.core.v1.ClusterTrustBundleProjectionPointer(currentPath / s"clusterTrustBundle")
  def serviceAccountToken :  io.k8s.api.core.v1.ServiceAccountTokenProjectionPointer = io.k8s.api.core.v1.ServiceAccountTokenProjectionPointer(currentPath / s"serviceAccountToken")
  def downwardAPI :  io.k8s.api.core.v1.DownwardAPIProjectionPointer = io.k8s.api.core.v1.DownwardAPIProjectionPointer(currentPath / s"downwardAPI")
}


